<?php $__env->startSection('title', 'Rent Management'); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
.rent-stat-card .card-body { display: flex; justify-content: space-between; align-items: flex-start; }
.rent-stat-card .stat-icon { width: 48px; height: 48px; border-radius: 0.5rem; display: inline-flex; align-items: center; justify-content: center; font-size: 1.5rem; }
.rent-stat-card .stat-value { font-size: 1.75rem; font-weight: 600; line-height: 1.2; }
.rent-stat-card .stat-label { color: var(--bs-secondary); font-size: 0.875rem; margin-top: 0.25rem; }
.rent-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.rent-user-cell .avatar-wrap { flex-shrink: 0; width: 38px; height: 38px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.875rem; background: var(--bs-secondary-bg); color: var(--bs-body-color); }
.rent-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.rent-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; letter-spacing: 0.02em; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Rent Management</h4>
        <a href="<?php echo e(route('admin.rents.create')); ?>" class="btn btn-primary"><i class="ri-add-line me-1"></i>Add Rent</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row g-4 mb-4">
        <div class="col-xl-4 col-sm-6">
            <div class="card rent-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block"><?php echo e(number_format($stats['rent_paid_count'] ?? 0)); ?></span>
                        <span class="stat-label">Rent Paid (current month)</span>
                    </div>
                    <div class="stat-icon bg-label-success"><i class="ri-money-rupee-circle-line"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6">
            <div class="card rent-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block">₹ <?php echo e(number_format($stats['rent_paid_total'] ?? 0, 2)); ?></span>
                        <span class="stat-label">Total Collected</span>
                    </div>
                    <div class="stat-icon bg-label-primary"><i class="ri-bank-line"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6">
            <div class="card rent-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block"><?php echo e(number_format($stats['rent_pending_count'] ?? 0)); ?></span>
                        <span class="stat-label">Rent Pending</span>
                    </div>
                    <div class="stat-icon bg-label-warning"><i class="ri-time-line"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form method="get" action="<?php echo e(route('admin.rents.index')); ?>" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="<?php echo e($fromDate ?? ''); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="<?php echo e($toDate ?? ''); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Mode</label>
                    <select class="form-select" name="payment_mode">
                        <option value="">All</option>
                        <?php $__currentLoopData = $paymentModes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e(($paymentMode ?? '') === $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <a href="<?php echo e(route('admin.rents.index')); ?>" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <ul class="nav nav-tabs mb-3" role="tablist">
        <li class="nav-item">
            <button type="button" class="nav-link active" data-bs-toggle="tab" data-bs-target="#rent-paid" role="tab">Rent Paid (<?php echo e($rentPaid->count()); ?>)</button>
        </li>
        <li class="nav-item">
            <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#rent-pending" role="tab">Rent Pending (<?php echo e($rentPending->count()); ?>)</button>
        </li>
    </ul>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="rent-paid" role="tabpanel">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table rent-table table-hover" id="rentPaidTable">
                            <thead>
                                <tr>
                                    <th>Receipt No.</th>
                                    <th>Student</th>
                                    <th>Period</th>
                                    <th>Amount</th>
                                    <th>Payment Mode</th>
                                    <th>Paid At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $rentPaid; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php $s = $r->student; ?>
                                    <tr>
                                        <td><?php echo e($r->receipt_no ?? 'R' . $r->id); ?></td>
                                        <td>
                                            <div class="rent-user-cell">
                                                <div class="avatar-wrap">
                                                    <?php if($s->documents->where('document_type', 'profile_photo')->first()): ?>
                                                        <img src="<?php echo e(asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path)); ?>" alt="">
                                                    <?php else: ?>
                                                        <?php echo e(strtoupper(mb_substr($s->first_name ?? '', 0, 1))); ?>

                                                    <?php endif; ?>
                                                </div>
                                                <div class="user-info">
                                                    <span class="user-name"><?php echo e($s->full_name); ?></span>
                                                    <span class="user-meta d-block"><?php echo e($s->student_mobile ?? '—'); ?></span>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($r->period_from->format('d/m/Y')); ?> – <?php echo e($r->period_to->format('d/m/Y')); ?></td>
                                        <td>₹ <?php echo e(number_format($r->amount, 2)); ?></td>
                                        <td><?php echo e($paymentModes[$r->payment_mode] ?? $r->payment_mode); ?></td>
                                        <td><?php echo e($r->paid_at?->format('d/m/Y H:i') ?? '—'); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-outline-primary view-receipt-btn" data-url="<?php echo e(route('admin.rents.receipt', $r)); ?>" title="View Receipt"><i class="ri-eye-line"></i></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td colspan="7" class="text-center text-muted py-4">No rent paid records for the selected period.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="rent-pending" role="tabpanel">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table rent-table table-hover" id="rentPendingTable">
                            <thead>
                                <tr>
                                    <th>Student</th>
                                    <th>Room / Bed</th>
                                    <th>Rent (Bed)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $rentPending; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="rent-user-cell">
                                                <div class="avatar-wrap">
                                                    <?php if($s->documents->where('document_type', 'profile_photo')->first()): ?>
                                                        <img src="<?php echo e(asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path)); ?>" alt="">
                                                    <?php else: ?>
                                                        <?php echo e(strtoupper(mb_substr($s->first_name ?? '', 0, 1))); ?>

                                                    <?php endif; ?>
                                                </div>
                                                <div class="user-info">
                                                    <span class="user-name"><?php echo e($s->full_name); ?></span>
                                                    <span class="user-meta d-block"><?php echo e($s->student_mobile ?? '—'); ?></span>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($s->room_bed_identifier ?? '—'); ?></td>
                                        <td>₹ <?php echo e($s->bed ? number_format($s->bed->rent_amount ?? 0, 2) : '—'); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.rents.create', ['student_id' => $s->id])); ?>" class="btn btn-sm btn-primary" title="Add Rent"><i class="ri-money-rupee-circle-line"></i> Add Rent</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td colspan="4" class="text-center text-muted py-4">No pending rent for current month.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="receiptModalTitle">Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="receiptModalBody">
                    <div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="printReceiptBtn"><i class="ri-printer-line me-1"></i>Print</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            #receiptModal, #receiptModal * {
                visibility: visible;
            }
            #receiptModal {
                position: fixed;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                z-index: 9999;
            }
            #receiptModal .modal-dialog {
                position: absolute;
                left: 0;
                top: 0;
                margin: 0;
                padding: 0;
                max-width: 100%;
                width: 100%;
            }
            #receiptModal .modal-content {
                border: none;
                box-shadow: none;
            }
            #receiptModal .modal-header,
            #receiptModal .modal-footer {
                display: none !important;
            }
            #receiptModal .modal-body {
                padding: 20px !important;
            }
        }
    </style>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
(function() {
    // Initialize DataTables
    $('#rentPaidTable').DataTable({
        order: [[5, 'desc']], // Sort by Paid At descending
        pageLength: 25,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ rents",
            infoEmpty: "No rents available",
            infoFiltered: "(filtered from _MAX_ total rents)"
        },
        columnDefs: [
            { orderable: false, targets: -1 } // Disable sorting on Action column
        ]
    });

    $('#rentPendingTable').DataTable({
        pageLength: 25,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ students",
            infoEmpty: "No pending rents",
            infoFiltered: "(filtered from _MAX_ total students)"
        },
        columnDefs: [
            { orderable: false, targets: -1 } // Disable sorting on Action column
        ]
    });

    // Receipt modal
    var receiptModalEl = document.getElementById('receiptModal');
    var modalTitle = document.getElementById('receiptModalTitle');
    var modalBody = document.getElementById('receiptModalBody');
    var printBtn = document.getElementById('printReceiptBtn');
    
    if (!receiptModalEl) return;
    
    // Print receipt button
    if (printBtn) {
        printBtn.addEventListener('click', function() {
            window.print();
        });
    }
    
    // Use event delegation for dynamically loaded buttons
    $(document).on('click', '.view-receipt-btn', function() {
        var url = $(this).attr('data-url');
        modalBody.innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>';
        
        // Show modal using Bootstrap's data-bs-toggle or create instance
        var modalInstance = window.bootstrap ? new bootstrap.Modal(receiptModalEl) : new Modal(receiptModalEl);
        modalInstance.show();
        
        fetch(url, {
            headers: {
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                modalTitle.textContent = data.title;
                modalBody.innerHTML = data.html;
            } else {
                modalBody.innerHTML = '<div class="alert alert-danger">Failed to load receipt</div>';
            }
        })
        .catch(error => {
            modalBody.innerHTML = '<div class="alert alert-danger">Error loading receipt</div>';
        });
    });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/rents/index.blade.php ENDPATH**/ ?>