<?php
use Illuminate\Support\Facades\Route;
?>

<ul class="menu-sub">
  <?php if(isset($menu)): ?>
    <?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    
    <?php
      $activeClass = null;
      $active = 'active open';
      $currentRouteName = Route::currentRouteName();
      $isRouteName = isset($submenu->url) && str_contains($submenu->url ?? '', '.') && !str_starts_with($submenu->url ?? '', 'http');

      if ($isRouteName && request()->routeIs($submenu->url)) {
        $activeClass = 'active';
      } elseif ($currentRouteName === ($submenu->slug ?? null)) {
        $activeClass = 'active';
      } elseif (isset($submenu->submenu)) {
        if (gettype($submenu->slug ?? null) === 'array') {
          foreach ($submenu->slug as $slug) {
            if (str_contains($currentRouteName, $slug) && strpos($currentRouteName, $slug) === 0) {
              $activeClass = $active;
            }
          }
        } else {
          if (isset($submenu->slug) && str_contains($currentRouteName, $submenu->slug) && strpos($currentRouteName, $submenu->slug) === 0) {
            $activeClass = $active;
          }
        }
      }
    ?>

    <?php
      $href = isset($submenu->url) ? ($isRouteName ? route($submenu->url) : url($submenu->url)) : 'javascript:void(0)';
    ?>

      <li class="menu-item <?php echo e($activeClass); ?>">
        <a href="<?php echo e($href); ?>" class="<?php echo e(isset($submenu->submenu) ? 'menu-link menu-toggle' : 'menu-link'); ?>" <?php if(isset($submenu->target) && !empty($submenu->target)): ?> target="<?php echo e($submenu->target); ?>" <?php endif; ?>>
          <?php if(isset($submenu->icon)): ?>
          <i class="<?php echo e($submenu->icon); ?>"></i>
          <?php endif; ?>
          <div><?php echo e(isset($submenu->name) ? __($submenu->name) : ''); ?></div>
          <?php if(isset($submenu->badge)): ?>
            <div class="badge bg-<?php echo e($submenu->badge[0]); ?> rounded-pill ms-auto"><?php echo e($submenu->badge[1]); ?></div>
          <?php endif; ?>
        </a>

        
        <?php if(isset($submenu->submenu)): ?>
          <?php echo $__env->make('layouts.sections.menu.submenu', ['menu' => $submenu->submenu], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
</ul>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/layouts/sections/menu/submenu.blade.php ENDPATH**/ ?>