<?php $__env->startSection('title', 'View Agreement'); ?>

<?php $__env->startSection('vendor-style'); ?>
<style>
.agreement-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.agreement-user-cell .avatar-wrap { flex-shrink: 0; width: 38px; height: 38px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.875rem; background: var(--bs-secondary-bg); }
.agreement-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.agreement-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Agreement & Expiry</h4>
        <a href="<?php echo e(route('admin.agreements.index')); ?>" class="btn btn-outline-secondary">All Agreements</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-body">
            <div class="btn-group" role="group">
                <a href="<?php echo e(route('admin.agreements.index', array_filter(['filter' => 'all', 'student_id' => $studentId]))); ?>" class="btn btn-<?php echo e(($filter ?? 'all') === 'all' ? 'primary' : 'outline-primary'); ?>">All</a>
                <a href="<?php echo e(route('admin.agreements.index', array_filter(['filter' => 'expiring_today', 'student_id' => $studentId]))); ?>" class="btn btn-<?php echo e(($filter ?? '') === 'expiring_today' ? 'primary' : 'outline-primary'); ?>">Expiring Today</a>
                <a href="<?php echo e(route('admin.agreements.index', array_filter(['filter' => 'expiring_week', 'student_id' => $studentId]))); ?>" class="btn btn-<?php echo e(($filter ?? '') === 'expiring_week' ? 'primary' : 'outline-primary'); ?>">This Week</a>
                <a href="<?php echo e(route('admin.agreements.index', array_filter(['filter' => 'expiring_30', 'student_id' => $studentId]))); ?>" class="btn btn-<?php echo e(($filter ?? '') === 'expiring_30' ? 'primary' : 'outline-primary'); ?>">In 30 Days</a>
            </div>
            <?php if($studentId): ?>
                <span class="ms-3 text-muted">Filtered by student ID: <?php echo e($studentId); ?></span>
            <?php endif; ?>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table agreement-table table-hover">
                    <thead>
                        <tr>
                            <th>Student</th>
                            <th>Room / Bed</th>
                            <th>Admission Date</th>
                            <th>Leaving Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $firstAg = $s->agreementHistories->sortBy('from_date')->first();
                                $latestAg = $s->agreementHistories->sortByDesc('to_date')->first();
                            ?>
                            <tr>
                                <td>
                                    <div class="agreement-user-cell">
                                        <div class="avatar-wrap">
                                            <?php if($s->documents->where('document_type', 'profile_photo')->first()): ?>
                                                <img src="<?php echo e(asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path)); ?>" alt="">
                                            <?php else: ?>
                                                <?php echo e(strtoupper(mb_substr($s->first_name ?? '', 0, 1))); ?>

                                            <?php endif; ?>
                                        </div>
                                        <div>
                                            <span class="fw-medium"><?php echo e($s->full_name); ?></span>
                                            <span class="d-block small text-muted"><?php echo e($s->student_mobile ?? '—'); ?></span>
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo e($s->room_bed_identifier ?? '—'); ?></td>
                                <td><?php echo e($firstAg?->from_date?->format('d/m/Y') ?? '—'); ?></td>
                                <td><?php echo e($latestAg?->to_date?->format('d/m/Y') ?? '—'); ?></td>
                                <td>
                                    <div class="d-flex gap-1 flex-wrap">
                                        <a href="<?php echo e(route('admin.agreements.view', $s)); ?>" target="_blank" class="btn btn-sm btn-outline-primary" title="View / Print Agreement"><i class="ri-file-text-line"></i> Agreement</a>
                                        <a href="<?php echo e(route('admin.agreements.renew', $s)); ?>" class="btn btn-sm btn-outline-success" title="Renew (Increase To Date)"><i class="ri-calendar-check-line"></i> Renew</a>
                                        <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#remarkModal<?php echo e($s->id); ?>" title="Add Remark"><i class="ri-chat-3-line"></i> Remark</button>
                                    </div>
                                    <?php echo $__env->make('admin.agreements._remark_modal', ['student' => $s], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="5" class="text-center text-muted py-4">No students with agreements match the selected filter.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/agreements/index.blade.php ENDPATH**/ ?>