<?php $__env->startSection('title', 'Notifications'); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
.stats-card {
    border-left: 4px solid;
    transition: transform 0.2s;
}
.stats-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}
.stats-card.unread {
    border-left-color: #ff4c51;
}
.stats-card.critical {
    border-left-color: #ffb400;
}
.stats-card.total {
    border-left-color: #299eff;
}
.stats-number {
    font-size: 2rem;
    font-weight: 700;
    color: #566a7f;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">
                <i class="ri-notification-3-line me-2"></i>Notifications
            </h4>
            <p class="text-muted mb-0 small">Stay updated with important events and pending tasks</p>
        </div>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-sm btn-label-secondary" onclick="markAllAsRead()">
                <i class="ri-check-double-line me-1"></i>Mark all as read
            </button>
            <button type="button" class="btn btn-sm btn-primary" onclick="syncNotifications()">
                <i class="ri-refresh-line me-1"></i>Refresh
            </button>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-4">
            <div class="card stats-card unread h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small fw-semibold">UNREAD NOTIFICATIONS</p>
                            <h3 class="stats-number mb-0" id="unread-count"><?php echo e(number_format($unreadCount)); ?></h3>
                            <small class="text-muted">Requires attention</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-danger">
                                <i class="ri-mail-unread-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card stats-card critical h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small fw-semibold">CRITICAL ALERTS</p>
                            <h3 class="stats-number mb-0" id="critical-count"><?php echo e(number_format($criticalCount ?? 0)); ?></h3>
                            <small class="text-muted">High priority</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-warning">
                                <i class="ri-alarm-warning-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card stats-card total h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small fw-semibold">TOTAL NOTIFICATIONS</p>
                            <h3 class="stats-number mb-0" id="total-count"><?php echo e(number_format($totalCount ?? 0)); ?></h3>
                            <small class="text-muted">All time</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-info">
                                <i class="ri-list-check ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications Table -->
    <div class="card">
        <div class="card-header pb-0">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                <h5 class="mb-0">All Notifications</h5>
                <!-- Filter Tabs -->
                <ul class="nav nav-pills" role="tablist">
                    <li class="nav-item">
                        <button type="button" class="nav-link <?php echo e($filter === 'all' ? 'active' : ''); ?> filter-tab" data-filter="all">
                            <i class="ri-list-check me-1"></i>All
                        </button>
                    </li>
                    <li class="nav-item">
                        <button type="button" class="nav-link <?php echo e($filter === 'unread' ? 'active' : ''); ?> filter-tab" data-filter="unread">
                            <i class="ri-mail-unread-line me-1"></i>Unread
                            <?php if($unreadCount > 0): ?>
                                <span class="badge rounded-pill bg-danger ms-1"><?php echo e($unreadCount > 99 ? '99+' : $unreadCount); ?></span>
                            <?php endif; ?>
                        </button>
                    </li>
                    <li class="nav-item">
                        <button type="button" class="nav-link <?php echo e($filter === 'critical' ? 'active' : ''); ?> filter-tab" data-filter="critical">
                            <i class="ri-alarm-warning-line me-1"></i>Critical
                        </button>
                    </li>
                </ul>
            </div>
        </div>
        <div class="card-datatable table-responsive">
            <table id="notificationsTable" class="table table-hover" style="width: 100%;">
                <thead>
                    <tr>
                        <th style="width: 60px;"></th>
                        <th>Category</th>
                        <th>Notification</th>
                        <th style="width: 200px;">Details</th>
                        <th style="width: 110px;">Time</th>
                        <th style="width: 110px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Data loaded via AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
(function() {
var $ = window.jQuery;
if (!$ || typeof $.fn.DataTable !== 'function') {
    console.error('jQuery or DataTables not loaded');
    return;
}
var currentFilter = '<?php echo e($filter); ?>';
var notificationsTable;

$(document).ready(function() {
    initializeDataTable();
    $('#notificationsTable').on('click', '.btn-view-notification', function(e) {
        e.preventDefault();
        const id = $(this).closest('.notification-actions').data('id');
        const url = $(this).attr('href') || '';
        markAsReadAndNavigate(e, id, url);
    });
    $('#notificationsTable').on('click', '.btn-mark-one', function(e) {
        e.preventDefault();
        const id = $(this).closest('.notification-actions').data('id');
        markAsRead(id);
    });
    $(document).on('click', '.filter-tab', function() {
        var filter = $(this).data('filter');
        if (filter) changeFilter(filter);
    });
});

function initializeDataTable() {
    if (notificationsTable) {
        notificationsTable.destroy();
    }

    notificationsTable = $('#notificationsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo e(route("admin.notifications.data")); ?>',
            type: 'POST',
            dataType: 'json',
            data: function(d) {
                d.filter = currentFilter;
                d._token = '<?php echo e(csrf_token()); ?>';
            },
            error: function(xhr, err, msg) {
                console.error('Notifications data error:', err, msg, xhr.responseText);
            }
        },
        columns: [
            {
                data: null,
                orderable: false,
                searchable: false,
                className: 'text-center',
                render: function(data, type, row) {
                    return getNotificationIcon(row.type, row.priority);
                }
            },
            {
                data: 'type_label',
                render: function(data, type, row) {
                    const label = data || row.type || '';
                    return `<span class="badge bg-label-secondary">${label}</span>`;
                }
            },
            {
                data: null,
                render: function(data, type, row) {
                    const unreadDot = !row.is_read ? '<span class="badge bg-primary rounded-pill ms-2" style="width: 8px; height: 8px; padding: 0;"></span>' : '';
                    const priorityBadge = getPriorityBadge(row.priority);
                    return `
                        <div>
                            <h6 class="mb-1 fw-semibold d-flex align-items-center">
                                ${row.title} ${unreadDot}
                            </h6>
                            <p class="mb-1 text-body small">${row.message}</p>
                            ${priorityBadge}
                        </div>
                    `;
                }
            },
            {
                data: null,
                render: function(data, type, row) {
                    let details = '<div class="small text-muted">';
                    if (row.meta && row.meta.room_bed) {
                        details += `<div class="mb-1"><i class="ri-door-line me-1"></i>${row.meta.room_bed}</div>`;
                    }
                    if (row.meta && row.meta.days_remaining) {
                        details += `<div class="mb-1"><i class="ri-time-line me-1"></i>${row.meta.days_remaining} days left</div>`;
                    }
                    if (row.meta && row.meta.days_overdue) {
                        details += `<div class="mb-1 text-danger"><i class="ri-alarm-warning-line me-1"></i>${row.meta.days_overdue} days overdue</div>`;
                    }
                    if (row.meta && row.meta.amount) {
                        details += `<div class="mb-1"><i class="ri-money-rupee-circle-line me-1"></i>₹${parseFloat(row.meta.amount).toLocaleString('en-IN', {minimumFractionDigits: 2})}</div>`;
                    }
                    details += '</div>';
                    return details;
                }
            },
            {
                data: 'time_ago',
                render: function(data, type, row) {
                    return `<span class="text-muted small">${data}</span>`;
                }
            },
            {
                data: null,
                orderable: false,
                searchable: false,
                className: 'text-center',
                render: function(data, type, row) {
                    const actionUrl = (row.action_url || '').replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/</g, '&lt;');
                    return `
                        <div class="d-flex gap-1 justify-content-center notification-actions" data-id="${row.id}">
                            <a href="${actionUrl}" class="btn btn-sm btn-icon btn-outline-primary btn-view-notification" title="View Details">
                                <i class="ri-eye-line"></i>
                            </a>
                            ${!row.is_read ? `<button type="button" class="btn btn-sm btn-icon btn-outline-success btn-mark-one" title="Mark as Read"><i class="ri-check-line"></i></button>` : ''}
                        </div>
                    `;
                }
            }
        ],
        order: [[4, 'desc']],
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        language: {
            search: '',
            searchPlaceholder: 'Search notifications...',
            lengthMenu: 'Show _MENU_',
            info: 'Showing _START_ to _END_ of _TOTAL_ notifications',
            infoEmpty: 'No notifications available',
            infoFiltered: '(filtered from _MAX_ total)',
            zeroRecords: 'No matching notifications found',
            emptyTable: 'No notifications available',
            processing: '<div class="d-flex justify-content-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>'
        },
        createdRow: function(row, data, dataIndex) {
            if (!data.is_read) {
                $(row).addClass('unread-row');
            }
        },
    });
}

function getNotificationIcon(type, priority) {
    const priorityClass = {
        'critical': 'bg-label-danger',
        'warning': 'bg-label-warning',
        'info': 'bg-label-info',
        'success': 'bg-label-success'
    }[priority] || 'bg-label-secondary';

    const iconMap = {
        'agreement_expiring': 'ri-file-text-line',
        'rent_due': 'ri-calendar-line',
        'rent_overdue': 'ri-alert-line',
        'deposit_low': 'ri-money-dollar-circle-line',
        'student_pending': 'ri-user-add-line'
    };

    const icon = iconMap[type] || 'ri-notification-line';

    return `
        <div class="avatar avatar-sm">
            <span class="avatar-initial rounded-circle ${priorityClass}">
                <i class="${icon}"></i>
            </span>
        </div>
    `;
}

function getPriorityBadge(priority) {
    const badges = {
        'critical': '<span class="badge bg-danger">Critical</span>',
        'warning': '<span class="badge bg-warning">Warning</span>',
        'info': '<span class="badge bg-info">Info</span>',
        'success': '<span class="badge bg-success">Success</span>'
    };
    return badges[priority] || '';
}

function changeFilter(filter) {
    currentFilter = filter;
    $('.filter-tab').removeClass('active');
    $(`.filter-tab[data-filter="${filter}"]`).addClass('active');
    notificationsTable.ajax.reload();
}

function markAsRead(notificationId) {
    fetch(`/admin/notifications/${notificationId}/mark-as-read`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            notificationsTable.ajax.reload(null, false);
            if (data.unread_count !== undefined) {
                $('#unread-count').text(data.unread_count.toLocaleString());
            }
            showToast('Notification marked as read', 'success');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Failed to mark as read', 'error');
    });
}

function markAsReadAndNavigate(event, notificationId, url) {
    event.preventDefault();
    
    fetch(`/admin/notifications/${notificationId}/mark-as-read`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        window.location.href = url;
    })
    .catch(error => {
        console.error('Error:', error);
        window.location.href = url;
    });
}

function markAllAsRead() {
    if (!confirm('Mark all notifications as read?')) return;

    fetch('/admin/notifications/mark-all-as-read', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            notificationsTable.ajax.reload();
            $('#unread-count').text('0');
            showToast('All notifications marked as read', 'success');
        }
    })
    .catch(error => {
        showToast('Failed to mark all as read', 'error');
    });
}

function syncNotifications() {
    const btn = event.target.closest('button');
    const originalHTML = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span>Syncing...';
    
    fetch('/admin/notifications/sync', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            notificationsTable.ajax.reload();
            if (data.unread_count !== undefined) $('#unread-count').text(data.unread_count.toLocaleString());
            if (data.critical_count !== undefined) $('#critical-count').text(data.critical_count.toLocaleString());
            if (data.total_count !== undefined) $('#total-count').text(data.total_count.toLocaleString());
            showToast('Notifications synced successfully', 'success');
        }
        btn.disabled = false;
        btn.innerHTML = originalHTML;
    })
    .catch(error => {
        showToast('Failed to sync notifications', 'error');
        btn.disabled = false;
        btn.innerHTML = originalHTML;
    });
}

function showToast(message, type) {
    const bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
    const icon = type === 'success' ? 'check-circle' : 'close-circle';
    const toast = `
        <div class="bs-toast toast fade show ${bgClass} text-white position-fixed top-0 end-0 m-3" role="alert" style="z-index: 9999;">
            <div class="toast-header ${bgClass} text-white border-0">
                <i class="ri-${icon}-line me-2"></i>
                <strong class="me-auto">${type === 'success' ? 'Success' : 'Error'}</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body">${message}</div>
        </div>
    `;
    $('body').append(toast);
    setTimeout(() => {
        $('.toast').fadeOut(300, function() {
            $(this).remove();
        });
    }, 3000);
}
})();
</script>

<style>
.unread-row {
    background-color: rgba(129, 89, 228, 0.04);
}

.unread-row:hover {
    background-color: rgba(129, 89, 228, 0.08);
}

#notificationsTable tbody tr:hover {
    cursor: pointer;
}

.dataTables_wrapper .dataTables_filter input {
    margin-left: 0.5em;
    border-radius: 0.375rem;
    padding: 0.4rem 0.875rem;
}

.dataTables_wrapper .dataTables_length select {
    padding: 0.4rem 2rem 0.4rem 0.875rem;
    border-radius: 0.375rem;
}

.table thead th {
    font-weight: 600;
    color: #566a7f;
    background-color: rgba(67, 89, 113, 0.04);
    border-bottom: 2px solid #e7e7e7;
    padding: 1rem 0.75rem;
}

.table tbody td {
    padding: 0.875rem 0.75rem;
    vertical-align: middle;
}

.nav-pills .nav-link {
    font-size: 0.875rem;
    padding: 0.5rem 1rem;
    border-radius: 0.375rem;
}

.nav-pills .nav-link.active {
    background-color: #8159E4;
}

.nav-pills .nav-link:not(.active):hover {
    background-color: rgba(129, 89, 228, 0.1);
}

.dataTables_info, .dataTables_paginate {
    padding: 1rem;
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/notifications/index.blade.php ENDPATH**/ ?>