<?php $__env->startSection('title', 'Deposit Receipt Book'); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
.receipt-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.receipt-user-cell .avatar-wrap { flex-shrink: 0; width: 36px; height: 36px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.75rem; background: var(--bs-secondary-bg); }
.receipt-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.receipt-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
@media print { .no-print { display: none !important; } .receipt-user-cell .avatar-wrap { display: none; } }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Deposit Receipt Book</h4>
        <div class="d-flex gap-2 no-print">
            <button type="button" class="btn btn-outline-success btn-sm" id="exportExcel" title="Export Excel"><i class="ri-file-excel-2-line me-1"></i>Excel</button>
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="window.print();" title="Print"><i class="ri-printer-line me-1"></i>Print</button>
        </div>
    </div>

    <div class="card mb-4 no-print">
        <div class="card-body">
            <form method="get" action="<?php echo e(route('admin.receipts.deposit')); ?>" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="<?php echo e($fromDate ?? ''); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="<?php echo e($toDate ?? ''); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Mode</label>
                    <select class="form-select" name="payment_mode">
                        <option value="">All</option>
                        <?php $__currentLoopData = $paymentModes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e(($paymentMode ?? '') === $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Search</button>
                    <a href="<?php echo e(route('admin.receipts.deposit')); ?>" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table receipt-table table-hover" id="depositReceiptTable">
                    <thead>
                        <tr>
                            <th>Receipt / Ref.</th>
                            <th>Student</th>
                            <th>Transaction Date</th>
                            <th>Period</th>
                            <th>Amount</th>
                            <th>Payment Mode</th>
                            <th class="no-print">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php $s = $d->student; ?>
                            <tr>
                                <td>D-<?php echo e($d->id); ?></td>
                                <td>
                                    <div class="receipt-user-cell">
                                        <div class="avatar-wrap">
                                            <?php if($s->documents->where('document_type', 'profile_photo')->first()): ?>
                                                <img src="<?php echo e(asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path)); ?>" alt="">
                                            <?php else: ?>
                                                <?php echo e(strtoupper(mb_substr($s->first_name ?? '', 0, 1))); ?>

                                            <?php endif; ?>
                                        </div>
                                        <div><span class="fw-medium"><?php echo e($s->full_name); ?></span><span class="d-block small text-muted"><?php echo e($s->student_mobile ?? '—'); ?></span></div>
                                    </div>
                                </td>
                                <td><?php echo e($d->actual_deposit_date?->format('d/m/Y') ?? '—'); ?></td>
                                <td><?php echo e($d->from_date?->format('d/m/Y') ?? '—'); ?> – <?php echo e($d->to_date?->format('d/m/Y') ?? '—'); ?></td>
                                <td>₹ <?php echo e(number_format($d->amount, 2)); ?></td>
                                <td><?php echo e($paymentModes[$d->payment_mode] ?? $d->payment_mode); ?></td>
                                <td class="no-print">
                                    <button type="button" class="btn btn-sm btn-outline-primary view-receipt-btn" data-url="<?php echo e(route('admin.receipts.deposit.print', $d)); ?>" title="View Receipt"><i class="ri-eye-line me-1"></i>View</button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="7" class="text-center text-muted py-4">No deposit records for the selected filter.</td></tr>
                        <?php endif; ?>
                    </tbody>
                    <?php if($deposits->isNotEmpty()): ?>
                    <tfoot>
                        <tr class="table-light fw-bold">
                            <td colspan="4" class="text-end">Total</td>
                            <td>₹ <?php echo e(number_format($total, 2)); ?></td>
                            <td></td>
                            <td class="no-print"></td>
                        </tr>
                    </tfoot>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="receiptModalTitle">Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="receiptModalBody">
                    <div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="printReceiptBtn"><i class="ri-printer-line me-1"></i>Print</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            #receiptModal, #receiptModal * {
                visibility: visible;
            }
            #receiptModal {
                position: fixed;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                z-index: 9999;
            }
            #receiptModal .modal-dialog {
                position: absolute;
                left: 0;
                top: 0;
                margin: 0;
                padding: 0;
                max-width: 100%;
                width: 100%;
            }
            #receiptModal .modal-content {
                border: none;
                box-shadow: none;
            }
            #receiptModal .modal-header,
            #receiptModal .modal-footer {
                display: none !important;
            }
            #receiptModal .modal-body {
                padding: 20px !important;
            }
        }
    </style>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
(function() {
    // Initialize DataTable
    var table = $('#depositReceiptTable').DataTable({
        order: [[2, 'desc']], // Sort by Transaction Date descending
        pageLength: 25,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ receipts",
            infoEmpty: "No receipts available",
            infoFiltered: "(filtered from _MAX_ total receipts)",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        },
        columnDefs: [
            { orderable: false, targets: -1 } // Disable sorting on Action column
        ]
    });

    var btn = document.getElementById('exportExcel');
    if (btn) btn.addEventListener('click', function() {
        var tableEl = document.getElementById('depositReceiptTable');
        if (!tableEl) return;
        var wb = XLSX.utils.table_to_book(tableEl, { sheet: 'Deposit Receipt Book', raw: true });
        XLSX.writeFile(wb, 'deposit-receipt-book-' + new Date().toISOString().slice(0,10) + '.xlsx');
    });

    // Receipt modal
    var receiptModalEl = document.getElementById('receiptModal');
    var modalTitle = document.getElementById('receiptModalTitle');
    var modalBody = document.getElementById('receiptModalBody');
    var printBtn = document.getElementById('printReceiptBtn');
    
    if (!receiptModalEl) return;
    
    // Print receipt button
    if (printBtn) {
        printBtn.addEventListener('click', function() {
            window.print();
        });
    }
    
    document.querySelectorAll('.view-receipt-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var url = this.getAttribute('data-url');
            modalBody.innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>';
            
            // Show modal using Bootstrap's data-bs-toggle or create instance
            var modalInstance = window.bootstrap ? new bootstrap.Modal(receiptModalEl) : new Modal(receiptModalEl);
            modalInstance.show();
            
            fetch(url, {
                headers: {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    modalTitle.textContent = data.title;
                    modalBody.innerHTML = data.html;
                } else {
                    modalBody.innerHTML = '<div class="alert alert-danger">Failed to load receipt</div>';
                }
            })
            .catch(error => {
                modalBody.innerHTML = '<div class="alert alert-danger">Error loading receipt</div>';
            });
        });
    });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/receipts/deposit.blade.php ENDPATH**/ ?>