<?php $__env->startSection('title', 'Edit Student'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">Edit Student Details</h4>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('admin.students.update', $student)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="first_name" value="<?php echo e(old('first_name', $student->first_name)); ?>" required />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Middle Name</label>
                        <input type="text" class="form-control" name="middle_name" value="<?php echo e(old('middle_name', $student->middle_name)); ?>" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Last Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="last_name" value="<?php echo e(old('last_name', $student->last_name)); ?>" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" value="<?php echo e(old('email', $student->email)); ?>" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Student Mobile</label>
                        <input type="text" class="form-control" name="student_mobile" value="<?php echo e(old('student_mobile', $student->student_mobile)); ?>" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Parent Mobile</label>
                        <input type="text" class="form-control" name="parent_mobile" value="<?php echo e(old('parent_mobile', $student->parent_mobile)); ?>" />
                    </div>
                    <div class="col-12">
                        <label class="form-label">Permanent Locality</label>
                        <input type="text" class="form-control" name="permanent_locality" value="<?php echo e(old('permanent_locality', $student->permanent_locality)); ?>" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">District</label>
                        <input type="text" class="form-control" name="permanent_district" value="<?php echo e(old('permanent_district', $student->permanent_district)); ?>" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">State</label>
                        <input type="text" class="form-control" name="permanent_state" value="<?php echo e(old('permanent_state', $student->permanent_state)); ?>" />
                    </div>
                </div>
                <hr class="my-4" />
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="<?php echo e(route('admin.students.show', $student)); ?>" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/students/edit.blade.php ENDPATH**/ ?>