/**
 * Copyright (C) 2018 Glayzzle (BSD3 License)
 * @authors https://github.com/glayzzle/php-parser/graphs/contributors
 * @url http://glayzzle.com
 */
"use strict";

const Statement = require("./statement");
const KIND = "foreach";

/**
 * Defines a foreach iterator
 * @constructor Foreach
 * @memberOf module:php-parser
 * @extends {Statement}
 * @property {Expression} source
 * @property {Expression|null} key
 * @property {Expression} value
 * @property {Block | null} body
 * @property {boolean} shortForm
 * @see http://php.net/manual/en/control-structures.foreach.php
 */
module.exports = Statement.extends(
  KIND,
  function Foreach(source, key, value, body, shortForm, docs, location) {
    Statement.apply(this, [KIND, docs, location]);
    this.source = source;
    this.key = key;
    this.value = value;
    this.shortForm = shortForm;
    this.body = body;
  }
);
